 <?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {
	public function __construct(){
		parent::__construct();

		// load Pagination library
        $this->load->library('pagination');

		$this->load->model('signteModel');
	}


	public function index(){
		$data['title'] = "Home";
		$data['active_menu'] = "home";

		$basicInformation = $this->signteModel->fetch_data('basic_details');
		foreach ($basicInformation as $basic) {
			$data['logo'] = $basic->logo;
			$data['mobile'] = $basic->mobile;
			$data['email'] = $basic->email;
			$data['address'] = $basic->address;
	
			$data['facebook'] = $basic->facebook;
			$data['twitter'] = $basic->twitter;
			$data['youtube'] = $basic->youtube;
			$data['instagram'] = $basic->instagram;
			$data['linkedin'] = $basic->linkedin;
			$data['tumblr'] = $basic->tumblr;
			
			$data['mobile2'] = $basic->mobile2;
			$data['mobile3'] = $basic->mobile3;
			$data['email2'] = $basic->email2;
			$data['email3'] = $basic->email3;
			$data['address2'] = $basic->address2;
			$data['address3'] = $basic->address3;
			$data['address4'] = $basic->address4;
		}

		$data['slider'] = $this->signteModel->fetch_data('slider');
		$data['AppCat'] = $this->signteModel->fetch_data('application_cat');
		$data['ProCat'] = $this->signteModel->fetch_data('category');
		$data['home_pro'] = $this->signteModel->fetch_limit(4, 0, 'category');

		$this->load->view('inc/header', $data);
		$this->load->view('inc/slider');
		$this->load->view('home');
		$this->load->view('inc/footer');
	}

	public function about(){
		$data['title'] = "About Us";
		$data['active_menu'] = "about";

		$basicInformation = $this->signteModel->fetch_data('basic_details');
		foreach ($basicInformation as $basic) {
			$data['logo'] = $basic->logo;
			$data['mobile'] = $basic->mobile;
			$data['email'] = $basic->email;
			$data['address'] = $basic->address;
	
			$data['facebook'] = $basic->facebook;
			$data['twitter'] = $basic->twitter;
			$data['youtube'] = $basic->youtube;
			$data['instagram'] = $basic->instagram;
			$data['linkedin'] = $basic->linkedin;
			$data['tumblr'] = $basic->tumblr;
			
			$data['mobile2'] = $basic->mobile2;
			$data['mobile3'] = $basic->mobile3;
			$data['email2'] = $basic->email2;
			$data['email3'] = $basic->email3;
			$data['address2'] = $basic->address2;
			$data['address3'] = $basic->address3;
			$data['address4'] = $basic->address4;
		}

		$data['about'] = $this->signteModel->fetch_data('about_us');
		$data['about_gallery'] = $this->signteModel->fetch_where('1', 'blogType', 'workshop');
		$data['about_blog'] = $this->signteModel->fetch_where('2', 'blogType', 'workshop');
		$data['AppCat'] = $this->signteModel->fetch_data('application_cat');
		$data['ProCat'] = $this->signteModel->fetch_data('category');

		$this->load->view('inc/header', $data);
		$this->load->view('about');
		$this->load->view('inc/footer');	
	}

	public function careers(){
		$data['title'] = "Contact Us";
		$data['active_menu'] = "career";

		$basicInformation = $this->signteModel->fetch_data('basic_details');
		foreach ($basicInformation as $basic) {
			$data['logo'] = $basic->logo;
			$data['mobile'] = $basic->mobile;
			$data['email'] = $basic->email;
			$data['address'] = $basic->address;
	
			$data['facebook'] = $basic->facebook;
			$data['twitter'] = $basic->twitter;
			$data['youtube'] = $basic->youtube;
			$data['instagram'] = $basic->instagram;
			$data['linkedin'] = $basic->linkedin;
			$data['tumblr'] = $basic->tumblr;
			
			$data['mobile2'] = $basic->mobile2;
			$data['mobile3'] = $basic->mobile3;
			$data['email2'] = $basic->email2;
			$data['email3'] = $basic->email3;
			$data['address2'] = $basic->address2;
			$data['address3'] = $basic->address3;
			$data['address4'] = $basic->address4;
		}

		$data['career'] = $this->signteModel->fetch_data('our_team');
		$data['AppCat'] = $this->signteModel->fetch_data('application_cat');
		$data['ProCat'] = $this->signteModel->fetch_data('category');

		
		$this->load->view('inc/header', $data);
		$this->load->view('careers');
		$this->load->view('inc/footer');	
	}

	public function contact(){
		$data['title'] = "Contact Us";
		$data['active_menu'] = "contact";

		$basicInformation = $this->signteModel->fetch_data('basic_details');
		foreach ($basicInformation as $basic) {
			$data['logo'] = $basic->logo;
			$data['mobile'] = $basic->mobile;
			$data['email'] = $basic->email;
			$data['address'] = $basic->address;
	
			$data['facebook'] = $basic->facebook;
			$data['twitter'] = $basic->twitter;
			$data['youtube'] = $basic->youtube;
			$data['instagram'] = $basic->instagram;
			$data['linkedin'] = $basic->linkedin;
			$data['tumblr'] = $basic->tumblr;
			
			$data['mobile2'] = $basic->mobile2;
			$data['mobile3'] = $basic->mobile3;
			$data['email2'] = $basic->email2;
			$data['email3'] = $basic->email3;
			$data['address2'] = $basic->address2;
			$data['address3'] = $basic->address3;
			$data['address4'] = $basic->address4;
		}

		$data['AppCat'] = $this->signteModel->fetch_data('application_cat');
		$data['ProCat'] = $this->signteModel->fetch_data('category');

		
		$this->load->view('inc/header', $data);
		$this->load->view('contact');
		$this->load->view('inc/footer');	
	}

	
	public function submitContact(){
		$post = $this->input->post();
		$date = $this->currentDate();


		if(!empty($post['name']) && !empty($post['email'])){
			$data = array(
				'name' => $post['name'],
				'email' => $post['email'],
				'subject' => $post['subject'],
				'message' => $post['message'],
				'create_at' => $date
			);
			$this->signteModel->save('contact', $data);
			
			
			// Mail Send Function using Ajax
            $config = array (
                'mailtype' => 'html',
                'charset'  => 'utf-8',
                'priority' => '1'
            );
            
            $bodyMsg = "<p style='font-size:14px;font-weight:normal;margin-bottom:10px;margin-top:0;'>
            Name : ".$post['name'].", 
            Email : ".$post['email'].", 
            Subject : ".$post['subject'].", 
            Message : ".$post['message']."</p>";
                                
            $dataMail = array(
                'topMsg'    => 'Hi', 
                'bodyMsg'   => $bodyMsg, 
                'thanksMsg' => 'Best regards,', 
                'delimeter' => 'Aerofiberacoustics'
            );
                
            $this->email->initialize($config);
            $this->email->from('info@aerofiberacoustics.com', 'Aerofiberacoustics');
            $this->email->to('info@aerofiberacoustics.com');
            $this->email->subject('Contact Message!!');
            $message = $this->load->view('mailHtml', $dataMail, TRUE);
            $this->email->message($bodyMsg);
            $sendMail = $this->email->send();       
            //--------------------------
			
			

			$this->session->set_flashdata('message', 'Your Message sent successfully!!');
			redirect(base_url('contact'));
		} else{
			$this->session->set_flashdata('message', 'Please fill all details!!');
			redirect(base_url('contact'));
		}
	}


	public function application_cat($catApp){
		
		$data['active_menu'] = "application";
		$data['cat_url'] = $catApp;

		$basicInformation = $this->signteModel->fetch_data('basic_details');
		foreach ($basicInformation as $basic) {
			$data['logo'] = $basic->logo;
			$data['mobile'] = $basic->mobile;
			$data['email'] = $basic->email;
			$data['address'] = $basic->address;
	
			$data['facebook'] = $basic->facebook;
			$data['twitter'] = $basic->twitter;
			$data['youtube'] = $basic->youtube;
			$data['instagram'] = $basic->instagram;
			$data['linkedin'] = $basic->linkedin;
			$data['tumblr'] = $basic->tumblr;
			
			$data['mobile2'] = $basic->mobile2;
			$data['mobile3'] = $basic->mobile3;
			$data['email2'] = $basic->email2;
			$data['email3'] = $basic->email3;
			$data['address2'] = $basic->address2;
			$data['address3'] = $basic->address3;
			$data['address4'] = $basic->address4;
		}

		$data['AppCat'] = $this->signteModel->fetch_data('application_cat');
		$data['ProCat'] = $this->signteModel->fetch_data('category');

		$catDetails = $this->signteModel->fetch_where($catApp, 'cat_url', 'application_cat');
		foreach ($catDetails as $row) {
			$data['catName'] = $row->name;
			$cat_id = $row->id;
			$data['title'] = $row->name;
		}

		$data['sub_cat'] = $this->signteModel->fetch_where_asc($cat_id, 'catid', 'app_sub_category');

		
		$this->load->view('inc/header', $data);
		$this->load->view('product/app_sub_cat');
		$this->load->view('inc/footer');
	}

	public function product_cat($pro, $catPro){
		
		$data['active_menu'] = "product";
		$data['cat_url'] = $catPro;

		$basicInformation = $this->signteModel->fetch_data('basic_details');
		foreach ($basicInformation as $basic) {
			$data['logo'] = $basic->logo;
			$data['mobile'] = $basic->mobile;
			$data['email'] = $basic->email;
			$data['address'] = $basic->address;
	
			$data['facebook'] = $basic->facebook;
			$data['twitter'] = $basic->twitter;
			$data['youtube'] = $basic->youtube;
			$data['instagram'] = $basic->instagram;
			$data['linkedin'] = $basic->linkedin;
			$data['tumblr'] = $basic->tumblr;
			
			$data['mobile2'] = $basic->mobile2;
			$data['mobile3'] = $basic->mobile3;
			$data['email2'] = $basic->email2;
			$data['email3'] = $basic->email3;
			$data['address2'] = $basic->address2;
			$data['address3'] = $basic->address3;
			$data['address4'] = $basic->address4;
		}

		$data['AppCat'] = $this->signteModel->fetch_data('application_cat');
		$data['ProCat'] = $this->signteModel->fetch_data('category');

		$catDetails = $this->signteModel->fetch_where($catPro, 'cat_url', 'category');
		foreach ($catDetails as $row) {
			$data['catName'] = $row->catName;
			$data['title'] = $row->catName;
			$cat_id = $row->ID;
		}

		$data['sub_cat'] = $this->signteModel->fetch_where_asc($cat_id, 'catid', 'sub_category');

		
		$this->load->view('inc/header', $data);
		$this->load->view('product/pro_sub_cat');
		$this->load->view('inc/footer');
	}

	public function application_sub_cat($catApp, $subCatApp){
		$data['title'] = $subCatApp;
		$data['active_menu'] = "application";
		$data['cat_url'] = $catApp;
         
         $category = $this->signteModel->fetch_where($catApp, 'cat_url', 'application_cat');
         foreach($category as $CatNew){
             $cat_id = $CatNew->id;
         }
         
         
		$basicInformation = $this->signteModel->fetch_data('basic_details');
		foreach ($basicInformation as $basic) {
			$data['logo'] = $basic->logo;
			$data['mobile'] = $basic->mobile;
			$data['email'] = $basic->email;
			$data['address'] = $basic->address;
	
			$data['facebook'] = $basic->facebook;
			$data['twitter'] = $basic->twitter;
			$data['youtube'] = $basic->youtube;
			$data['instagram'] = $basic->instagram;
			$data['linkedin'] = $basic->linkedin;
			$data['tumblr'] = $basic->tumblr;
			
			$data['mobile2'] = $basic->mobile2;
			$data['mobile3'] = $basic->mobile3;
			$data['email2'] = $basic->email2;
			$data['email3'] = $basic->email3;
			$data['address2'] = $basic->address2;
			$data['address3'] = $basic->address3;
			$data['address4'] = $basic->address4;
		}

		$data['AppCat'] = $this->signteModel->fetch_data('application_cat');
		$data['ProCat'] = $this->signteModel->fetch_data('category');

		$data['catDetails'] = $this->signteModel->fetch_where_pro_detail($subCatApp, 'cat_url_title', 'app_sub_category', $cat_id);

		
		$this->load->view('inc/header', $data);
		$this->load->view('product/app_sub_cat_details');
		$this->load->view('inc/footer');
	}

	public function product_sub_cat($pro, $catPro, $subCatPro){
		$data['title'] = $subCatPro;
		$data['active_menu'] = "product";
		$data['cat_url'] = $subCatPro;
		
		
         $category = $this->signteModel->fetch_where($catPro, 'cat_url', 'category');
         foreach($category as $CatNew){
             $cat_id = $CatNew->ID;
         }

		$basicInformation = $this->signteModel->fetch_data('basic_details');
		foreach ($basicInformation as $basic) {
			$data['logo'] = $basic->logo;
			$data['mobile'] = $basic->mobile;
			$data['email'] = $basic->email;
			$data['address'] = $basic->address;
	
			$data['facebook'] = $basic->facebook;
			$data['twitter'] = $basic->twitter;
			$data['youtube'] = $basic->youtube;
			$data['instagram'] = $basic->instagram;
			$data['linkedin'] = $basic->linkedin;
			$data['tumblr'] = $basic->tumblr;
			
			$data['mobile2'] = $basic->mobile2;
			$data['mobile3'] = $basic->mobile3;
			$data['email2'] = $basic->email2;
			$data['email3'] = $basic->email3;
			$data['address2'] = $basic->address2;
			$data['address3'] = $basic->address3;
			$data['address4'] = $basic->address4;
		}

		$data['AppCat'] = $this->signteModel->fetch_data('application_cat');
		$data['ProCat'] = $this->signteModel->fetch_data('category');

		$data['catDetails'] = $this->signteModel->fetch_where_pro_detail($subCatPro, 'cat_url_title', 'sub_category', $cat_id);

		
		$this->load->view('inc/header', $data);
		$this->load->view('product/app_sub_cat_details');
		$this->load->view('inc/footer');
	}





	public function currentDate(){
    	date_default_timezone_set('Asia/Calcutta');
    	return $date=date("Y-m-d H:i:s");
    }

}
