<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Basic_information extends CI_Controller {
	function __construct(){
          parent::__construct();
          $this->load->model('admin/AdminModel');

          error_reporting(0);

          if( ! $this->session->userdata('userid')){
          	return  redirect(base_url('Administrator'));
          }
    }

    public function index(){
    	return redirect(base_url('Master/basic_information/home_about'));
    }
	public function home_about(){

		$data['title'] = "Home About | Admin";

    $data['getId'] = $this->input->get('id');
    $data['getPage'] = $this->input->get('page');

    $teamVal = $this->AdminModel->editTeamValue($this->input->get('id'));
    //echo $this->db->last_query();
    foreach ($teamVal as $team) {
      $data['teamId'] = $team->id;
      $data['teamImage'] = $team->imageName;
      $data['description'] = $team->name;
    }

    $data['getPage'] = $_GET['page'];
    $data['offset'] = 12;

    $data['page'] = $_GET['page'];
    if($data['page'] == "" || $data['page'] == "1"){
        $data['page1']=0;
        $data['z'] = 0;
    } else {
        $data['page1'] = ($data['page']*$data['offset'])-$data['offset'];
        $data['z'] = ($data['page']*$data['offset'])-$data['offset'];
    }
    $data['team_member'] = $this->AdminModel->viewTeamMember($data['page1'], $data['offset']);
    $data['catNumRows'] = $this->AdminModel->teamCount();

		$this->load->view('admin/inc/header', $data);
		$this->load->view('admin/basic_information/team');
		$this->load->view('admin/inc/sidebar');
		$this->load->view('admin/inc/footer');
	}

  public function exhibition(){
    $data['title'] = "SPONSORS | Admin";


    $data['getId'] = $this->input->get('id');
    $data['getPage'] = $this->input->get('page');

    $teamVal = $this->AdminModel->editExhibitionValue($this->input->get('id'));
    //echo $this->db->last_query();
    foreach ($teamVal as $team) {
      $data['exhibitionId'] = $team->id;
      $data['exhibitionImage'] = $team->imageName;
    }

    $data['getPage'] = $_GET['page'];
    $data['offset'] = 12;

    $data['page'] = $_GET['page'];
    if($data['page'] == "" || $data['page'] == "1"){
        $data['page1']=0;
        $data['z'] = 0;
    } else {
        $data['page1'] = ($data['page']*$data['offset'])-$data['offset'];
        $data['z'] = ($data['page']*$data['offset'])-$data['offset'];
    }
    $data['exhibition_image'] = $this->AdminModel->viewExhibition($data['page1'], $data['offset']);
    $data['catNumRows'] = $this->AdminModel->exhibitionCount();

    $this->load->view('admin/inc/header', $data);
    $this->load->view('admin/basic_information/exhibition');
    $this->load->view('admin/inc/sidebar');
    $this->load->view('admin/inc/footer');
  }

  public function team_add(){
    $file1 = $this->_do_upload('image_path');
    $fileName = $this->upload->data('file_name');
    $date = $this->currentDate();
    $user = $this->session->userdata('userid');

    if( !empty($fileName)){
      $this->AdminModel->insertTeam($fileName);
      return redirect(base_url('Master/basic_information/team?succ=1'));
    } else {
      return redirect(base_url('Master/basic_information/team?err=1'));
    }
  }

  public function team_update(){
    $page = $this->input->post('page');
    $updateId = $this->input->post('teamId');
    $description = $this->input->post('description');
    $date = $this->currentDate();
    $user = $this->session->userdata('userid');

    $file1 = $this->_do_upload('image_path');
    $fileName = $this->upload->data('file_name');
    if( ! empty($fileName)){
      $uploadImage = $fileName;
    } else {
      $uploadImage = $this->input->post('oldFile');
    }

    $this->AdminModel->updateTeam($updateId, $uploadImage, $description);
    return redirect(base_url('Master/basic_information/home_about?page='.$page.'&succ=1'));
  }

  public function deleteTeam(){
    $id = $_GET['id'];
    $page = $_GET['page'];
    
    $this->db->delete('our_team', array('id' => $id));
    return redirect(base_url('Master/basic_information/team?page='.$page.'&del=1'));
  }


  // Exhibition

  public function exhibition_add(){
    $file1 = $this->_do_upload('image_path');
    $fileName = $this->upload->data('file_name');
    $date = $this->currentDate();
    $user = $this->session->userdata('userid');

    if( !empty($fileName)){
      $this->AdminModel->insertExhibition($fileName);
      return redirect(base_url('Master/basic_information/exhibition?succ=1'));
    } else {
      return redirect(base_url('Master/basic_information/exhibition?err=1'));
    }
  }

  public function exhibition_update(){
    $page = $this->input->post('page');
    $updateId = $this->input->post('exhibitionId');
    $date = $this->currentDate();
    $user = $this->session->userdata('userid');

    $file1 = $this->_do_upload('image_path');
    $fileName = $this->upload->data('file_name');
    if( ! empty($fileName)){
      $uploadImage = $fileName;
    } else {
      $uploadImage = $this->input->post('oldFile');
    }

    $this->AdminModel->updateExhibition($updateId, $uploadImage);
    return redirect(base_url('Master/basic_information/exhibition?page='.$page.'&succ=1'));
  }

  public function deleteExhibition(){
    $id = $_GET['id'];
    $page = $_GET['page'];
    
    $this->db->delete('exhibition', array('id' => $id));
    return redirect(base_url('Master/basic_information/exhibition?page='.$page.'&del=1'));
  }


  // ===== Workshop

  public function workshop(){
    $data['title'] = "About Blog | Admin";


    $data['getId'] = $this->input->get('id');
    $data['getPage'] = $this->input->get('page');

    $teamVal = $this->AdminModel->editWorkshopValue($this->input->get('id'));
    //echo $this->db->last_query();
    foreach ($teamVal as $team) {
      $data['exhibitionId'] = $team->id;
      $data['exhibitionImage'] = $team->imageName;
      $data['name'] = $team->name;
      $data['paragraph'] = $team->paragraph;
      $data['blogType'] = $team->blogType;
    }

    $data['getPage'] = $_GET['page'];
    $data['offset'] = 12;

    $data['page'] = $_GET['page'];
    if($data['page'] == "" || $data['page'] == "1"){
        $data['page1']=0;
        $data['z'] = 0;
    } else {
        $data['page1'] = ($data['page']*$data['offset'])-$data['offset'];
        $data['z'] = ($data['page']*$data['offset'])-$data['offset'];
    }
    $data['workshop_image'] = $this->AdminModel->viewWorkshop($data['page1'], $data['offset']);
    $data['catNumRows'] = $this->AdminModel->workshopCount();

    $this->load->view('admin/inc/header', $data);
    $this->load->view('admin/basic_information/workshop');
    $this->load->view('admin/inc/sidebar');
    $this->load->view('admin/inc/footer');
  }


  public function workshop_add(){
    $file1 = $this->_do_upload('image_path');
    $fileName = $this->upload->data('file_name');
    $date = $this->currentDate();
    $user = $this->session->userdata('userid');
    $name = $this->input->post('name');
    $paragraph = $this->input->post('paragraph');
    $blogType = $this->input->post('blogType');

    if( !empty($fileName)){
      $this->AdminModel->insertWorkshop($fileName, $name, $paragraph, $blogType);
      return redirect(base_url('Master/basic_information/workshop?succ=1'));
    } else {
      return redirect(base_url('Master/basic_information/workshop?err=1'));
    }
  }

  public function workshop_update(){
    $page = $this->input->post('page');
    $updateId = $this->input->post('exhibitionId');
    $date = $this->currentDate();
    $user = $this->session->userdata('userid');
    $name = $this->input->post('name');
    $paragraph = $this->input->post('paragraph');
    $blogType = $this->input->post('blogType');

    $file1 = $this->_do_upload('image_path');
    $fileName = $this->upload->data('file_name');
    if( ! empty($fileName)){
      $uploadImage = $fileName;
    } else {
      $uploadImage = $this->input->post('oldFile');
    }

    $this->AdminModel->updateWorkshop($updateId, $uploadImage, $name, $paragraph, $blogType);
    return redirect(base_url('Master/basic_information/workshop?page='.$page.'&succ=1'));
  }

  public function deleteWorkshop(){
    $id = $_GET['id'];
    $page = $_GET['page'];
    
    $this->db->delete('workshop', array('id' => $id));
    return redirect(base_url('Master/basic_information/workshop?page='.$page.'&del=1'));
  }

  //=== Basic

  public function basic(){
    $data['title'] = "Basic | Admin";

    $user = $this->AdminModel->editBasicValue();
    foreach ($user as $user) {
      $data['mobile'] = $user->mobile;
      $data['mobile2'] = $user->mobile2;
      $data['mobile3'] = $user->mobile3;
      $data['email'] = $user->email;
      $data['email2'] = $user->email2;
      $data['email3'] = $user->email3;
      $data['address'] = $user->address;
      $data['address2'] = $user->address2;
      $data['address3'] = $user->address3;
      $data['address4'] = $user->address4;
      $data['address_1'] = $user->address_1;
      $data['logo'] = $user->logo;
      $data['facebook'] = $user->facebook;
      $data['twitter'] = $user->twitter;
      $data['instagram'] = $user->instagram;
      $data['youtube'] = $user->youtube;
      $data['small_about'] = $user->small_about;
      $data['linkedin'] = $user->linkedin;
      $data['tumblr'] = $user->tumblr;
    }
    

    $this->load->view('admin/inc/header', $data);
    $this->load->view('admin/basic_information/basic', $data);
    $this->load->view('admin/inc/sidebar');
    $this->load->view('admin/inc/footer');
  }

  public function update_basic(){
    $post = $this->input->post();

    $file1 = $this->_do_upload('image_path');
    $fileName = $this->upload->data('file_name');
    if( ! empty($fileName)){
      $uploadImage = $fileName;
    } else {
      $uploadImage = $this->input->post('oldFile');
    }

    $this->AdminModel->updateBasicValues($post['mobile'], $post['mobile2'], $post['mobile3'], $post['email'], $post['email2'], $post['email3'], $post['address'], $post['address2'], $post['address3'], $post['address4'],  $post['address_1'], $post['small_about'], $post['facebook'], $post['twitter'], $post['instagram'], $post['youtube'], $post['linkedin'], $post['tumblr'], $uploadImage);
    return redirect(base_url('Master/basic_information/basic?page=succ=1'));
  }

  public function about_us(){
    $data['title'] = "About Us | Admin";

    $data['about_us'] = $this->AdminModel->editAboutUsValue();    

    $this->load->view('admin/inc/header', $data);
    $this->load->view('admin/basic_information/about_us', $data);
    $this->load->view('admin/inc/sidebar');
    $this->load->view('admin/inc/footer'); 
  }

  public function update_about_us(){
    $post = $this->input->post();

    // About Image
    if($this->_do_upload('image_path')){
      $file1 = $this->_do_upload('image_path');
      $fileName = $this->upload->data('file_name');
      if( ! empty($fileName)){
        $uploadImage1 = $fileName;
      } else {
        $uploadImage1 = $this->input->post('oldFile');
      }
    } else {
      $uploadImage1 = $this->input->post('oldFile');
    }
    // Mission Image
    if($this->_do_upload('image_path1')){
      $file2 = $this->_do_upload('image_path1');
      $fileName2 = $this->upload->data('file_name');
      if( ! empty($fileName2)){
        $uploadImage2 = $fileName2;
      } else {
        $uploadImage2 = $this->input->post('oldFile1');
      }
    } else {
      $uploadImage2 = $this->input->post('oldFile1');
    }
    // Vission Image
    if($this->_do_upload('image_path2')){
      $file3 = $this->_do_upload('image_path2');
      $fileName3 = $this->upload->data('file_name');
      if( ! empty($fileName3)){
        $uploadImage3 = $fileName3;
      } else {
        $uploadImage3 = $this->input->post('oldFile2');
      }
    } else {
      $uploadImage3 = $this->input->post('oldFile2');
    }
    

    $this->AdminModel->updateAboutUs($post['heading'], $uploadImage1, $post['aboutContent'], $post['experience'], $post['industries'], $post['products'], $post['mission'], $post['vission'], $uploadImage2, $uploadImage3, $post['feature_1'], $post['feature_1_icon'], $post['feature_2'], $post['feature_2_icon'], $post['feature_3'], $post['feature_3_icon']);
    redirect(base_url('Master/basic_information/about_us?succ=1'));


  }



  public function _do_upload($filename){
    $config['upload_path']          = './public/uploads/basic_information';
    $config['allowed_types']        = 'gif|jpg|png|jpeg';
        //$config['max_size']             = 100;
        //$config['max_width']            = 1024;
        //$config['max_height']           = 768;
        $this->load->library('upload', $config);
        if ( ! $this->upload->do_upload($filename)){
            //$error = array('error' => $this->upload->display_errors());
            //$this->load->view('upload_form', $error);
            return false;
        } else {
            $data = array('upload_data' => $this->upload->data());
            //$this->load->view('upload_success', $data);
            //$data = $this->upload->data();
            $this->_do_resize($data['upload_data']['full_path'],$data['upload_data']['file_name']);
            return $post[$filename] = $data['upload_data']['file_name'];
        }
    }
    public function _do_resize($path,$file) {
        $config['image_library'] = 'gd2';
        $config['source_image'] = $path;
        //$config['create_thumb'] = TRUE;
        $config['maintain_ratio'] = TRUE;
        $config['width']         = 1000;
        $config['height']       = 600;
        $config['new_image']       = './public/uploads/basic_information/thumb/'.$file;
        $this->load->library('image_lib', $config);
        $this->image_lib->initialize($config);
        $this->image_lib->resize();
        if ( ! $this->image_lib->resize()) {
            echo $this->image_lib->display_errors();
        }

    }


    public function currentDate(){
      date_default_timezone_set('Asia/Calcutta');
      return $date=date("Y-m-d H:i:s");
    }



}
