
<?php
/**
 * 
 */
class SignteModel extends CI_Model
{
	
	function __construct(){
		$this->load->database();
	}


	public function fetch_data($tbaleName){
		$q = $this->db
			->select('*')
			->from($tbaleName)
			->order_by('id', 'desc')
			->get();
		return $q->result();
	}

	public function fetch_where($where, $column, $table){
		$q = $this->db
			->select('*')
			->from($table)
			->where($column, $where)
			->get();
		return $q->result();
	} 
	
	public function fetch_where_pro_detail($where, $column, $table, $catid){
		$q = $this->db
			->select('*')
			->from($table)
			->where($column, $where)
			->where('catid', $catid)
			->get();
		return $q->result();
	} 
	
	public function fetch_where_asc( $where, $column, $table){
	    $q = $this->db
			->select('*')
			->from($table)
			->where($column, $where)
			->order_by('id', 'asc')
			->get();
		return $q->result();
	}

	public  function save($table, $data){
		return $this->db->insert($table, $data);
	}

	public function get_total($table, $column, $where){
		$q = $this->db
			->select('*')
			->from($table)
			->where($column, $where)
			->get();
		return $q->num_rows();
	}

	public function fetch_where_limit($limit, $start, $table, $column, $where){
        $q = $this->db
			->select('*')
			->from($table)
			->where($column, $where)
			->order_by('id', 'desc')
			->limit($limit, $start)
			->get();
		return $q->result();
    }

    public function fetch_limit($limit, $start, $table){
        $q = $this->db
			->select('*')
			->from($table)
			->order_by('id', 'desc')
			->limit($limit, $start)
			->get();
		return $q->result();
    }

	
}