<?php

	/**
	 * 
	 */
	class AdminModel extends CI_Model
	{
		
		function __construct(){
		}

		public function ViewContact($limit, $offset){
			$q = $this->db
				->SELECT('*')
				->FROM('contact')
				->ORDER_BY('ID', 'DESC')
				->LIMIT($offset, $limit)
				->get();
			return $q->result();
		}

		public function numContRow(){
			$q = $this->db
				->SELECT('ID')
				->FROM('contact')
				->get();
			return $q->num_rows();
		}
		
		public function ViewSlider($limit, $offset){
			$q = $this->db
				->SELECT('*')
				->FROM('slider')
				->ORDER_BY('id', 'DESC')
				->LIMIT($offset, $limit)
				->get();
			return $q->result();
		}

		public function slideCount(){
			$q = $this->db
				->SELECT('id')
				->FROM('slider')
				->get();
			return $q->num_rows();
		}
		
		public function editSliderValue($id){
			$q = $this->db
				->SELECT('*')
				->FROM('slider')
				->where('id', $id)
				->ORDER_BY('id', 'DESC')
				->get();
			return $q->result();
		}
		
		public function insertSlider($heading, $paragraph, $url_link, $fileName){
			$data = array(
				'heading' => $heading,
				'paragraph' => $paragraph,
				'url_link' => $url_link,
				'imageName' => $fileName
			);
			
			return $this->db->insert('slider', $data);
		}
		
		public function updateSlider($updateId, $heading, $paragraph, $url_link, $uploadImage){
			$data = array(
				'heading' => $heading,
				'paragraph' => $paragraph,
				'url_link' => $url_link,
				'imageName' => $uploadImage
			);
			$this->db->where('id', $updateId);
			$this->db->update('slider', $data);
		}

		// Team Start
		public function insertTeam($fileName){
			$data = array(
				'imageName' => $fileName
			);
			
			return $this->db->insert('our_team', $data);
		}

		public function updateTeam($updateId, $uploadImage, $description){
			$data = array(
				'imageName' => $uploadImage,
				'name' => $description
			);
			$this->db->where('id', $updateId);
			$this->db->update('our_team', $data);
		}

		public function editTeamValue($id){
			$q = $this->db
				->SELECT('*')
				->FROM('our_team')
				->where('id', $id)
				->get();
			return $q->result();	
		}

		public function viewTeamMember(){
			$q = $this->db
				->SELECT('*')
				->FROM('our_team')
				->ORDER_BY('id', 'desc')
				->get();
			return $q->result();
		}

		public function teamCount(){
			$q = $this->db
				->SELECT('*')
				->FROM('our_team')
				->get();
			return $q->num_rows();
		}

		// Exihbition Start

		

		// Workshop Start

		public function insertWorkshop($fileName, $name, $paragraph, $blogType){
			$data = array(
				'imageName' => $fileName,
				'name' => $name,
				'paragraph' => $paragraph,
				'blogType' => $blogType
			);
			
			return $this->db->insert('workshop', $data);
		}

		public function updateWorkshop($updateId, $uploadImage, $name, $paragraph, $blogType){
			$data = array(
				'imageName' => $uploadImage,
				'name' => $name,
				'paragraph' => $paragraph,
				'blogType' => $blogType
			);
			$this->db->where('id', $updateId);
			$this->db->update('workshop', $data);
		}

		public function editWorkshopValue($id){
			$q = $this->db
				->SELECT('*')
				->FROM('workshop')
				->where('id', $id)
				->get();
			return $q->result();	
		}

		public function viewWorkshop(){
			$q = $this->db
				->SELECT('*')
				->FROM('workshop')
				->ORDER_BY('id', 'desc')
				->get();
			return $q->result();
		}

		public function workshopCount(){
			$q = $this->db
				->SELECT('*')
				->FROM('workshop')
				->get();
			return $q->num_rows();
		}

		public function editBasicValue(){
			$q = $this->db
				->SELECT('*')
				->FROM('basic_details')
				->where('id', 1)
				->get();
			return $q->result();
		}

		public function updateBasicValues($mobile, $mobile2, $mobile3, $email, $email2, $email3, $address, $address2, $address3, $address4, $address_1, $small_about, $facebook, $twitter, $instagram, $youtube, $linkedin, $tumblr, $uploadImage){
			$data = array(
				'mobile' => $mobile,
				'mobile2' => $mobile2,
				'mobile3' => $mobile3,
				'email' => $email,
				'email2' => $email2,
				'email3' => $email3,
				'address' => $address,
				'address2' => $address2,
				'address3' => $address3,
				'address4' => $address4,
				'address_1' => $address_1,
				'small_about' => $small_about,
				'facebook' => $facebook,
				'twitter' => $twitter,
				'youtube' => $youtube,
				'instagram' => $instagram,
				'linkedin' => $linkedin,
				'tumblr' => $tumblr,
				'logo' => $uploadImage
			);

			$this->db->where('id', 1);
			$this->db->update('basic_details', $data);
		}

		

		

		public function editAboutUsValue(){
			$q = $this->db
				->SELECT('*')
				->FROM('about_us')
				->where('id', 1)
				->ORDER_BY('id', 'DESC')
				->get();
			return $q->result();
		}

		public function updateAboutUs($heading, $uploadImage1, $aboutContent, $experience, $industries, $products, $mission, $vission, $uploadImage2, $uploadImage3, $feature_1, $feature_1_icon, $feature_2, $feature_2_icon, $feature_3, $feature_3_icon){
			$data = array(
				'heading' => $heading,
				'about_image' => $uploadImage1,
				'about_text' => $aboutContent,
				'experience' => $experience,
				'industries' => $industries,
				'products' => $products,
				'mission' => $mission,
				'vission' => $vission,
				'mission_image' => $uploadImage2,
				'vission_image' => $uploadImage3,
				'feature_1' => $feature_1,
				'feature_1_icon' => $feature_1_icon,
				'feature_2' => $feature_2,
				'feature_2_icon' => $feature_2_icon,
				'feature_3' => $feature_3,
				'feature_3_icon' => $feature_3_icon
			);

			$this->db->where('id', 1);
			$this->db->update('about_us', $data);
		}

		// Application Start

		public function insertAppCat($name, $catTitleUrl){
			$data = array(
				'name' => $name,
				'cat_url' => $catTitleUrl
			);
			
			return $this->db->insert('application_cat', $data);
		}

		public function updateAppCat($updateId, $name, $catTitleUrl){
			$data = array(
				'name' => $name,
				'cat_url' => $catTitleUrl
			);
			$this->db->where('id', $updateId);
			$this->db->update('application_cat', $data);
		}

		public function editAppCatValue($id){
			$q = $this->db
				->SELECT('*')
				->FROM('application_cat')
				->where('id', $id)
				->get();
			return $q->result();	
		}

		public function viewAppCat(){
			$q = $this->db
				->SELECT('*')
				->FROM('application_cat')
				->ORDER_BY('id', 'desc')
				->get();
			return $q->result();
		}

		public function AppCatCount(){
			$q = $this->db
				->SELECT('*')
				->FROM('application_cat')
				->get();
			return $q->num_rows();
		}

		// ====== Sub Category
		public function checkDelCategory($id){
			$q = $this->db
				->SELECT('id')
				->FROM('app_sub_category')
				->WHERE('catid', $id)
				->get();
			return $q->num_rows();
		}

		public function editSubCatValue($id){
			$q = $this->db
				->SELECT('*')
				->FROM('app_sub_category')
				->WHERE('ID', $id)
				->get();
			return $q->result();
		}

		public function ViewCategoryForSubCat(){
			$q = $this->db
				->SELECT('*')
				->FROM('application_cat')
				->order_by('ID', 'DESC')
				->get();
			return $q->result();
		}

		public function checkSubCategory($catTitle){
			$q = $this->db
				->SELECT('ID')
				->FROM('app_sub_category')
				->WHERE('title', $catTitle)
				->get();
			return $q->num_rows();
		}

		public function insertSubCat($catTitle, $cat_id, $fileName, $catTitleUrl, $content, $uploadImage1, $uploadImage2, $uploadImage3, $uploadImage4, $uploadImage5, $uploadImage6, $uploadImage7, $uploadImage8, $uploadImage9, $uploadImage10, $uploadImage11, $uploadImage12, $uploadImage14){
			$data = array(
				'title' => $catTitle,
				'catid' => $cat_id,
				'sub_cat_image' => $fileName,
				'status' => 1,
				'cat_url_title' => $catTitleUrl,
				'content' => $content,
				'image_path1' => $uploadImage1,
				'image_path2' => $uploadImage2,
				'image_path3' => $uploadImage3,
				'image_path4' => $uploadImage4,
				'image_path5' => $uploadImage5,
				'image_path6' => $uploadImage6,
				'image_path7' => $uploadImage7,
				'image_path8' => $uploadImage8,
				'image_path9' => $uploadImage9,
				'image_path10' => $uploadImage11,
				'image_path11' => $uploadImage11,
				'image_path12' => $uploadImage12,
				'image_path14' => $uploadImage14
			);
			return $this->db->insert('app_sub_category', $data);	
		}

		public function ViewSubCategory($limit="", $offset=""){
			$q = $this->db
				->SELECT('app_sub_category.*, application_cat.name')
				->FROM('app_sub_category')
				->join('application_cat', 'application_cat.id = app_sub_category.catid')
				->ORDER_BY('app_sub_category.ID', 'DESC')
				->LIMIT($offset, $limit)
				->get();
			return $q->result();
		}

		public function numSubCatRow(){
			$q = $this->db
				->SELECT('ID')
				->FROM('app_sub_category')
				->get();
			return $q->num_rows();
		}

		public function updateSubCat($updateId, $catTitle, $cat_id, $uploadImage, $catTitleUrl, $content, $uploadImage1, $uploadImage2, $uploadImage3, $uploadImage4, $uploadImage5, $uploadImage6, $uploadImage7, $uploadImage8, $uploadImage9, $uploadImage10, $uploadImage11, $uploadImage12, $uploadImage14){
			$data = array(
				'title' => $catTitle,
				'catid' => $cat_id,
				'sub_cat_image' => $uploadImage,
				'cat_url_title' => $catTitleUrl,
				'content' => $content,
				'image_path1' => $uploadImage1,
				'image_path2' => $uploadImage2,
				'image_path3' => $uploadImage3,
				'image_path4' => $uploadImage4,
				'image_path5' => $uploadImage5,
				'image_path6' => $uploadImage6,
				'image_path7' => $uploadImage7,
				'image_path8' => $uploadImage8,
				'image_path9' => $uploadImage9,
				'image_path10' => $uploadImage11,
				'image_path11' => $uploadImage11,
				'image_path12' => $uploadImage12,
				'image_path14' => $uploadImage14
			);
			$this->db->where('ID', $updateId);
			$this->db->update('app_sub_category', $data);
		}

	}