<?php

	/**
	 * 
	 */
	class CategoryModel extends CI_Model
	{
		
		function __construct(){
		}

		public function insertCat($catTitle, $catTitleUrl, $catHeadng, $fileName, $date, $user){
			$data = array(
				'catName' => $catTitle,
				'cat_url' => $catTitleUrl,
				'catHeadng' => $catHeadng,
				'catImage' => $fileName,
				'create_at' => $date,
				'create_by' => $user
			);
			return $this->db->insert('category', $data);
		}

		public function checkCategory($catTitle){
			$q = $this->db
				->SELECT('ID')
				->FROM('category')
				->WHERE('catName', $catTitle)
				->get();
			return $q->num_rows();
		}

		public function ViewCategory($limit="", $offset=""){
			$q = $this->db
				->SELECT('*')
				->FROM('category')
				->ORDER_BY('ID', 'DESC')
				->LIMIT($offset, $limit)
				->get();
			return $q->result();
		}

		public function numCatRow(){
			$q = $this->db
				->SELECT('ID')
				->FROM('category')
				->get();
			return $q->num_rows();
		}

		public function editCatValue($id){
			$q = $this->db
				->SELECT('*')
				->FROM('category')
				->WHERE('ID', $id)
				->get();
			return $q->result();
		}

		public function updateCat($id, $catTitle, $catTitleUrl, $catHeadng, $uploadImage, $date, $user){
			$data = array(
				'catName' => $catTitle,
				'cat_url' => $catTitleUrl,
				'catHeadng' => $catHeadng,
				'catImage' => $uploadImage,
				'modify_at' => $date,
				'modify_by' => $user
			);
			$this->db->where('ID', $id);
			$this->db->update('category', $data);
		}

		
		public function checkDelCategory($id){
			$q = $this->db
				->SELECT('id')
				->FROM('sub_category')
				->WHERE('catid', $id)
				->get();
			return $q->num_rows();
		}

		public function editSubCatValue($id){
			$q = $this->db
				->SELECT('*')
				->FROM('sub_category')
				->WHERE('ID', $id)
				->get();
			return $q->result();
		}

		public function ViewCategoryForSubCat(){
			$q = $this->db
				->SELECT('*')
				->FROM('category')
				->order_by('ID', 'DESC')
				->get();
			return $q->result();
		}

		public function checkSubCategory($catTitle){
			$q = $this->db
				->SELECT('ID')
				->FROM('sub_category')
				->WHERE('title', $catTitle)
				->get();
			return $q->num_rows();
		}

		public function insertSubCat($catTitle, $cat_id, $fileName, $catTitleUrl, $content, $uploadImage1, $uploadImage2, $uploadImage3, $uploadImage4, $uploadImage5, $uploadImage6, $uploadImage7, $uploadImage8, $uploadImage9, $uploadImage10, $uploadImage11, $uploadImage12, $uploadImage14){
			$data = array(
				'title' => $catTitle,
				'catid' => $cat_id,
				'sub_cat_image' => $fileName,
				'status' => 1,
				'cat_url_title' => $catTitleUrl,
				'content' => $content,
				'image_path1' => $uploadImage1,
				'image_path2' => $uploadImage2,
				'image_path3' => $uploadImage3,
				'image_path4' => $uploadImage4,
				'image_path5' => $uploadImage5,
				'image_path6' => $uploadImage6,
				'image_path7' => $uploadImage7,
				'image_path8' => $uploadImage8,
				'image_path9' => $uploadImage9,
				'image_path10' => $uploadImage11,
				'image_path11' => $uploadImage11,
				'image_path12' => $uploadImage12,
				'image_path14' => $uploadImage14
			);
			return $this->db->insert('sub_category', $data);	
		}

		public function ViewSubCategory($limit="", $offset=""){
			$q = $this->db
				->SELECT('sub_category.*, category.catName')
				->FROM('sub_category')
				->join('category', 'category.id = sub_category.catid')
				->ORDER_BY('sub_category.ID', 'DESC')
				->LIMIT($offset, $limit)
				->get();
			return $q->result();
		}

		public function numSubCatRow(){
			$q = $this->db
				->SELECT('ID')
				->FROM('sub_category')
				->get();
			return $q->num_rows();
		}

		public function checkDelSubCategory($id){
			$q = $this->db
				->SELECT('id')
				->FROM('products')
				->WHERE('sub_cat_id', $id)
				->get();
			return $q->num_rows();
		}

		public function updateSubCat($updateId, $catTitle, $cat_id, $uploadImage, $catTitleUrl, $content, $uploadImage1, $uploadImage2, $uploadImage3, $uploadImage4, $uploadImage5, $uploadImage6, $uploadImage7, $uploadImage8, $uploadImage9, $uploadImage10, $uploadImage11, $uploadImage12, $uploadImage14){
			$data = array(
				'title' => $catTitle,
				'catid' => $cat_id,
				'sub_cat_image' => $uploadImage,
				'cat_url_title' => $catTitleUrl,
				'content' => $content,
				'image_path1' => $uploadImage1,
				'image_path2' => $uploadImage2,
				'image_path3' => $uploadImage3,
				'image_path4' => $uploadImage4,
				'image_path5' => $uploadImage5,
				'image_path6' => $uploadImage6,
				'image_path7' => $uploadImage7,
				'image_path8' => $uploadImage8,
				'image_path9' => $uploadImage9,
				'image_path10' => $uploadImage11,
				'image_path11' => $uploadImage11,
				'image_path12' => $uploadImage12,
				'image_path14' => $uploadImage14
			);
			$this->db->where('ID', $updateId);
			$this->db->update('sub_category', $data);
		}


		/*-========= Products ==========*/
		public function insertProducts($prod_name, $category, $sub_cat_name, $description, $fileName, $date, $user, $prod_name_url){
			$data = array(
				'pro_name' => $prod_name,
				'cat_id' => $category,
				'sub_cat_id' => $sub_cat_name,
				'description' => $description,
				'product_image' => $fileName,
				'create_date' => $date,
				'create_user' => $user,
				'prod_name_url' => $prod_name_url
			);
			return $this->db->insert('products', $data);
		}

		public function ViewProduct($limit="", $offset = ""){
			$q = $this->db
				->SELECT('products.*, category.catName')
				->FROM('products')
				->join('category', 'products.cat_id = category.ID', 'left')
				->ORDER_BY('products.id', 'DESC')
				->LIMIT($offset, $limit)
				->get();
			return $q->result();
		}

		public function productCount(){
			$q = $this->db
				->SELECT('id')
				->FROM('products')
				->get();
			return $q->num_rows();
		}

		public function editProductValue($id){
			$q = $this->db
				->SELECT('*')
				->FROM('products')
				->WHERE('id', $id)
				->get();
			return $q->result();
		}

		public function updateProduct($updateId, $prod_name, $category, $sub_cat_name, $description, $uploadImage, $date, $user, $prod_name_url){
			$data = array(
				'pro_name' => $prod_name,
				'cat_id' => $category,
				'sub_cat_id' => $sub_cat_name,
				'description' => $description,
				'product_image' => $uploadImage,
				'update_date' => $date,
				'update_user' => $user,
				'prod_name_url' => $prod_name_url 
			);
			$this->db->where('id', $updateId);
			$this->db->update('products', $data);
		}
	}